<?php
/* --------------------------------------------------------------
   PermissionRepository.php 2020-04-16
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2020 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Core\Permission;

/**
 * Interface PermissionRepository
 *
 * @package Gambio\Core\Permission
 */
interface PermissionRepository
{
    /**
     * Returns the permissions for a provided user and permission definition.
     *
     * @param UserId               $id
     * @param PermissionDefinition $permissionDefinition
     *
     * @return Permission
     */
    public function getPermission(
        UserId $id,
        PermissionDefinition $permissionDefinition
    ): Permission;
}